/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.helpers.OptimizedExplosion;
import carpet.logging.LoggerRegistry;
import carpet.logging.logHelpers.ExplosionLogHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5362;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1927.class})
public abstract class Explosion_optimizedTntMixin {
    @Shadow
    @Final
    private ObjectArrayList<class_2338> field_9188;
    @Shadow
    @Final
    private class_1937 field_9187;
    private ExplosionLogHelper eLogger;

    @Inject(method={"explode"}, at={@At(value="HEAD")}, cancellable=true)
    private void onExplosionA(CallbackInfo ci) {
        if (CarpetSettings.optimizedTNT) {
            OptimizedExplosion.doExplosionA((class_1927)this, this.eLogger);
            ci.cancel();
        }
    }

    @Inject(method={"finalizeExplosion"}, at={@At(value="HEAD")}, cancellable=true)
    private void onExplosionB(boolean spawnParticles, CallbackInfo ci) {
        if (this.eLogger != null) {
            this.eLogger.setAffectBlocks(!this.field_9188.isEmpty());
            this.eLogger.onExplosionDone(this.field_9187.method_8510());
        }
        if (CarpetSettings.explosionNoBlockDamage) {
            this.field_9188.clear();
        }
        if (CarpetSettings.optimizedTNT) {
            OptimizedExplosion.doExplosionB((class_1927)this, spawnParticles);
            ci.cancel();
        }
    }

    @Redirect(method={"explode"}, require=0, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"))
    private class_2680 noBlockCalcsWithNoBLockDamage(class_1937 world, class_2338 pos) {
        if (CarpetSettings.explosionNoBlockDamage) {
            return class_2246.field_9987.method_9564();
        }
        return world.method_8320(pos);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Explosion$BlockInteraction;)V"}, at={@At(value="RETURN")})
    private void onExplosionCreated(class_1937 world, class_1297 entity, class_1282 damageSource, class_5362 explosionBehavior, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType, CallbackInfo ci) {
        if (LoggerRegistry.__explosions && !world.field_9236) {
            this.eLogger = new ExplosionLogHelper(x, y, z, power, createFire, destructionType);
        }
    }

    @Redirect(method={"explode"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"))
    private void setVelocityAndUpdateLogging(class_1297 entity, class_243 velocity) {
        if (this.eLogger != null) {
            this.eLogger.onEntityImpacted(entity, velocity.method_1020(entity.method_18798()));
        }
        entity.method_18799(velocity);
    }
}

